%This program runs the simulations behind Fig. OA.2, OA.3, and OA.4.

%It conducts 1000 experiments of 1.10^6 episodes, with 2 AMMs, Delta_v = 4
%and \sigma = 5, for different values of alpha and beta, and records
%all the variables in the last episode.

%The program first runs the adverse selection case and then the private
%values case.

clear

% record running time
% when producing the data the running time was 197936 seconds.

tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.    
N = 2;                  %N is the number of AMMs.

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

grid_middle = 8;
grid_size= 69;  
tick= 0.1;     

% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
% Can be commented out to run without parallelization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

% define the 9 (alpha,beta) pairs.
alpha_l = 0.001;
alpha_m = 0.01;
alpha_h = 0.1;
beta_l = 5*10^(-6);
beta_m = 8*10^(-5);
beta_h = 3.2*10^(-4);

params = [alpha_l beta_l ; alpha_l beta_m ; alpha_l beta_h ; alpha_m beta_l ; alpha_m beta_m ; alpha_m beta_h ; alpha_h beta_l ; alpha_h beta_m ; alpha_h beta_h];

%Simulate for 9 values of sigma_l
for sigma_l = 1:9

%Simulate for 9 values of (alpha,beta), adverse selection case:

 for iter = 1:9
    %Display sigma_l and iter to follow the execution of the program
    disp('adverse selection')
    disp([sigma_l, iter])
    %Call the function simulation_rep to run K experiments
    [last_episodes]=simulation_rep(params(iter,1),params(iter,2),T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
    %Save the output in the subfolder "Data"
    writematrix(last_episodes,sprintf("Data/last_episodes_%d_%d.txt",sigma_l,iter));
 end

%Simulate for 9 values of (alpha,beta), private values case:

for iter = 1:9
    %Display sigma_l and iter to follow the execution of the program
    disp('private values')
    disp([sigma_l, iter])
    %Call the function simulation_rep_private to run K experiments
    [last_episodes]=simulation_rep_private(params(iter,1),params(iter,2),T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
    %Save the output in the subfolder "Data"
    writematrix(last_episodes,sprintf("Data/last_episodes_private_%d_%d.txt",sigma_l,iter));
end
end

toc